clear all
% Runs a battery of test problems for the Acoustics Toolbox

% These are a lot of cases ... You may need to run groups of cases
% separately to avoid having your computer freeze due to too many figures
% or memory issues

%%
% receiver at z = 0 m has a slightly different shape in sparc vs. sparcM
% This is because sparc has a bandpass filter
% If you comment out the line calling BandPass, then you get a perfect match
% Note that the Hanning window is currently disabled in sparc.f90

% SPARC
sparc( 'iso' )
plotts( 'iso.rts' )

%%
% bounce
bounce( 'refl' )
plotbrc( 'refl' )

%%
cases = [ 'free       '; ...
          'VolAtt     '; ...
          'halfspace  '; ...
          'calib      '; ...
          'Munk       '; ...
          'MunkLeaky  '; ...
          'MunkRot    '; ...
          'sduct      '; ...
          'Dickins    '; ...
          'arctic     '; ...  % 10
          'SBCX       '; ...
          'BeamPattern'; ...
          'TabRefCoef '; ...
          'PointLine  '; ...
          'ParaBot    '; ...
          'Ellipse    '; ...
          'terrain    '; ...
          '3DAtlantic '; ...
          'wedge      '; ...
          'Gulf       '; ...  % 20
          'block      '; ...
          'PekerisRD  '; ...
          'step       '; ...
          'BroadBand  '; ...
          'SedAtten   '; ...
          'head       '; ...
          'TLslices   '; ...
          'Noise      '; ...   % uses a lot of memory and time
              ];

for icase = 1 : size( cases, 1 )
    directory = deblank( cases( icase, : ) );
    fprintf( '\n *** Changing to directory %s', directory )
    eval( [ 'cd ' directory ] )

    % launch matlab in the background
    % eval( [ '! ' matlabroot '/bin/matlab -r runtests &' ] )
    runtests
    drawnow
    cd ..
end
