% sspfilt
% Take a tabulated SSP and produce a smooth approximation to it
% suitable for input to BELLHOP
% MBP 1998

% make sure the SSP includes surface and bottom points,
% otherwise the linear interpolation will produce NaN's

A = [ 0             1512.76
      0.245000      1512.76
      1.34000      1512.76
      2.47500      1512.73
      3.56000      1512.70
      4.97500      1512.66
      6.15700      1512.62
      7.26900      1512.58
      9.08200      1512.52
      11.1140      1508.49
      12.9850      1502.27
      15.5260      1499.21
      17.9650      1497.55
      20.3120      1495.91
      22.3840      1495.01
      24.1840      1494.23
      25.4930      1493.91
      26.7110      1493.68
      28.3280      1493.28
      29.6570      1492.78
      30.6250      1492.33
      32.0350      1492.18
      33.7020      1492.14
      35.3550      1492.14
      37.3630      1492.10
      39.2190      1491.37
      41.0820      1490.53
      43.0540      1490.26
      45.1360      1490.19
      46.4880      1490.23
      47.3460      1490.11
      48.9520      1490.13
      50.4530      1490.14
      51.5790      1490.11
      52.9110      1490.09
      54.8040      1490.13
      56.4560      1490.18
      57.7510      1490.20
      59.1810      1490.17
      60.4450      1490.18
      61.5130      1490.21
      63.4840      1490.35
      65.7620      1490.39
      67.6930      1490.36
      69.4310      1490.35
      71.5510      1490.30
      73.5020      1490.29
      75.0700      1490.15
      76.6490      1490.13
      78.1730      1490.12
      79.5250      1490.14
      80.7290      1490.15
      82.1510      1490.15
      83.5010      1490.17
      84.6740      1490.16
      86.2910      1490.17
      87.9980      1490.19
      89.3880      1490.20
      90.7430      1490.21
      92.3630      1490.23
      93.9130      1490.26
      94.8020      1490.28
      96.0050      1490.30
      97.2800      1490.32
      98.6270      1490.36
      99.7250      1490.36
      100.625      1490.31
      101.697      1490.03
      102.865      1489.96
      103.699      1489.96
      104.306      1489.96
      105.641      1489.99
      107.241      1489.95
      108.508      1489.96
      109.392      1489.91
      110.191      1489.91
      111.189      1489.91
      111.908      1489.85
      112.554      1489.77
      113.356      1489.72
      114.379      1489.62
      115.316      1489.41
      116.210      1489.27
      116.829      1489.18
      117.593      1489.03
      118.389      1488.98
      119.108      1489.02
      120.148      1489.00
      121.659      1488.99
      122.896      1488.96
      123.809      1488.91
      124.547      1488.92
      125.576      1488.91
      126.783      1488.94
      127.865      1488.95
      129.360      1488.97
      130.598      1488.98
      131.590      1488.99
      133.136      1488.99
      134.470      1489.01
      135.389      1489.04
      136.446      1489.05
      137.868      1489.06
      139.388      1489.09
      140.817      1489.04
      142.320      1488.99
      143.802      1488.93
      145.067      1488.88
      146.488      1488.85
      147.781      1488.85
      149.246      1488.92
      150.527      1488.98
      151.725      1488.93
      153.294      1488.83
      154.516      1488.88
      155.561      1488.88
      156.685      1488.90
      157.720      1488.95
      159.023      1488.97
      160.813      1489.02
      162.484      1489.06
      163.169      1489.03
      164.212      1489.01
      165.861      1488.98
      167.444      1488.96
      168.486      1488.95
      169.763      1488.96
      171.552      1489.25
      172.864      1489.32
      173.794      1489.32
      174.872      1489.33
      176.183      1489.33
      177.511      1489.36
      178.296      1489.37
      179.520      1489.39
      181.130      1489.39
      182.381      1489.37
      183.344      1489.37
      184.203      1489.38
      185.359      1489.38
      185.430      1489.38
      185.463      1489.38
      185.525      1489.38
      186.0        1489.38 ];

z = A( :, 1 );
c = A( :, 2 );

D = z( length( z ) );   % water depth

N = 1000; % points to use in sampling c(z)

% resample onto a uniform grid

zint = linspace( 0, D, N )';
cint = interp1( z, c, zint, 'linear' );
%cspline = interp1( z, c, zint, 'spline' );

figure
plot( z, c )
hold on
plot( zint, cint )
%plot( zint, cspline )

% decimate and plot (this gives a low-pass filtered SSP)

idec = 20
zdec = zint( 1:idec:N );
cdec = decimate( cint, idec );
cdec = cdec + mean( cint ) - mean( cdec );
%plot( zdec, cdec )

% Approach II: remove linear term

ctop = cint( 1 );
cbot = cint( N );
trend = linspace( ctop, cbot, N )';
cflat = cint - trend;

% decimate and interpolate to low-pass filter the SSP

idec = 20
zdec = zint( 1:idec:N );
cdec = decimate( cflat, idec );
Ndec = size( cdec, 1 );
c_resamp = interp( cdec( 1:Ndec-1, 1 ), 2 );

% add back linear term

N2 = size( c_resamp, 1 );
trend2 = linspace( ctop, cbot, N2 )';
c_resamp = c_resamp + trend2;
z_resamp = linspace( 0.0, D, N2 )';

figure
plot( z, c )
hold on
plot( z_resamp, c_resamp )

% write it out

B = [ z_resamp, c_resamp ]

fid = fopen( 'ssp.dat', 'w' );
fprintf( fid, '%f %f / \r\n', B' );

fclose( fid );



